#Created on December 21, 2013 by Connor Spiess
#You can check out my website @ http://cspiess.wordpress.com
#version 1.0

#Set your company name below. 
$CompanyName = "My Company"
#Set your mail server IP Address or Hostname below
$smtpserver = "mailserver.com"
#Below is where the log of users with expiring passwords will be written.
#Example: C:\Program Files\Password Notification\Log
#If this path does not exist you will need to create the folder structure from above.
$path = $env:PROGRAMFILES + '\Password Notification\Log'
#Set the email From address
$FromEmail = "fromemail@domainname.com"

Import-Module ActiveDirectory
#You will need to edit the search base For your domain. 
#Example: If you domainname is domain.com you would do "DC=domain,DC=com" to search your whole Active Directory structure
#If you want to narrow it down you can search specific Organization Units like Users then you would do "OU=Users,DC=Domain,DC=com"
Get-ADUser -filter * -properties PasswordLastSet,EmailAddress,GivenName,PasswordNeverExpires,PasswordExpired,Enabled -SearchBase "DC=Domain,DC=Com" |
Where-Object {$_.PasswordNeverExpires -ne "False" -and $_.PasswordExpired -ne "False" -and $_.Enabled -eq "True" -and $_.EmailAddress -ne $null} |
foreach {
   $PasswordSetDate=$_.PasswordLastSet
   $maxPasswordAgeTimeSpan = $null
   $maxPasswordAgeTimeSpan = (Get-ADDefaultDomainPasswordPolicy).MaxPasswordAge 
   $logdate = Get-Date -format yyyyMMdd
   $today=get-date
   $ExpiryDate=$passwordSetDate + $maxPasswordAgeTimeSpan
   $daysleft=$ExpiryDate-$today
   $display=$daysleft.days
   $UserName=$_.GivenName
   $EmailAddress=$_.EmailAddress
#The -lt 15 will notify a user there password is about to expire in the next 14 days. 
#You can adjust the the 15 to your choosing. 
if ($display -lt 15 -and $display -gt 0){
#The body below is targeted towards a Windows domain with an Exchange server. 
#You can modify the body to suite you environment. 
$EmailBody = @"
	Dear $UserName
  
	Please change your password to prevent loss of access to your $CompanyName systems`n
	If you are on the $CompanyName network proceed with the following:
	 -press ctrl-alt-delete
	 -Select Change Password
	 -Type in your old password and then type the new one (you cannot use one of the previously used passwords)
	 -After the change is complete you will be prompted with information that password has been changed.`n
	If you are not on the $CompanyName network proceed with the following:
	 -Open your web browser and go to https://mail.domainname.com/owa
	 -Login with you current username and password
	 -In the top right select Options
	 -Select Change Your Password
	 -Type in your old password and then type the new one (you cannot use one of the previously used passwords)
	 -After the change is complete you will be prompted with information that password has been changed.`n
    If you are unable to change your password, please contact the help desk at by entering a ticket through https://help.domainname.com or calling XXX.XXX.XXXX`n
	With Regards,
	The Help Desk
 
*** This is automatically generated email ***

"@
$subject = "Your Network password will expire in $display day(s) please change your password." 
send-mailmessage -to $_.EmailAddress -from $FromEmail -Subject $subject -body $EmailBody  -smtpserver $smtpserver
Write-Host "Email was sent to $EmailAddress on $today, and current password expires: $ExpiryDate"
Add-Content $path\maillog$logdate.txt  "Email was sent to $EmailAddress on $today, and current password expires: $ExpiryDate"
}
}
Send-MailMessage -To "helpdesk@domainname.com" -From $FromEmail -Subject "Password change log for $today" -Body "This is the log from $today" -Attachments $path\maillog$logdate.txt -SmtpServer $smtpserver
#This will get the current date and go back 15 days. 
$limit = (Get-Date).AddDays(-15)
Write-Host "$limit and $path"
#This will go into the log folder and delete any files older the 14 days. 
Get-ChildItem -Path $path -Force | Where-Object { !$_.PSIsContainer -and $_.CreationTime -lt $limit } | Remove-Item -Force